<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function postHistory()
    {
        return $this->hasMany('\App\Model\PostHistory');
    }

    public function socialMediaType()
    {
        return $this->hasOne('\App\Model\SocialMediaTypes');
    }

    public function influencer()
    {
        return $this->belongsTo('\App\Model\Influencer');
    }

}